#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization \"Reservoir\""
show title

$Expt << END
#                                          Tb           Tc          Pc                                                                      Visc
# Component        MW          SG          (F)         (R)        (psia)        AF         VTran         Zc        ZcVis       Pchor        (cp)
#-----------   ---------   ---------   ----------   ---------   ---------   ---------   ----------   ---------   ---------   ---------   ----------
   CO2           44.010     0.76193     -126.879      547.42     1069.51     0.22500      0.00191     0.27433     0.27433       80.00          NaN
   C1            16.043     0.14609     -258.868      343.01      667.03     0.01100     -0.14996     0.28620     0.28620       71.00          NaN
   C2            30.070     0.32976     -127.690      549.58      706.62     0.09900     -0.06280     0.27924     0.27924      111.00          NaN
   C3            44.097     0.50977      -43.989      665.69      616.12     0.15200     -0.06381     0.27630     0.27630      151.00          NaN
   C4            57.526     0.59498       28.693      767.19      564.18     0.18391     -0.05763     0.27699     0.27699      173.06          NaN
   C5            71.459     0.64541       93.829      848.76      505.26     0.22824     -0.03281     0.27152     0.27152      206.50          NaN
   C6-C7         90.253     0.69615      171.286      943.40      447.79     0.27872     -0.00408     0.26537     0.26537      251.61          NaN
   C8-C10       125.094     0.75937      293.137     1084.15      373.32     0.36624      0.03625     0.25578     0.25802      335.23      0.34740
   C11-C14      173.081     0.81235      429.111     1228.46      305.44     0.48715      0.07330     0.24516     0.25466      450.39      0.68469
   C15-C19      234.994     0.85324      567.216     1362.65      248.33     0.63036      0.10338     0.23367     0.25460      598.98      1.39764
   C20-C29      333.292     0.89018      730.132     1508.32      193.27     0.84297      0.12703     0.21771     0.25845      834.90      3.35369
   C30+         613.585     0.93436     1005.138     1733.80      123.80     1.31355      0.12802     0.18277     0.27844     1507.60     16.21888
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_001_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_001_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_001_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:9 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_001_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:10 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_001_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:12 with points notitle

set title "EOS Fluid Characterization \"Surface\""
show title

$Expt << END
#                                          Tb           Tc          Pc                                                                       Visc
# Component        MW          SG          (F)         (R)        (psia)        AF         VTran         Zc        ZcVis       Pchor         (cp)
#-----------   ---------   ---------   ----------   ---------   ---------   ---------   ----------   ---------   ---------   ---------   -----------
   CO2           44.010     0.76193     -126.879      547.42     1069.51     0.22500      0.00191     0.27433     0.27433       80.00           NaN
   C1            16.043     0.14609     -258.868      343.01      667.03     0.01100     -0.14996     0.28620     0.28620       71.00           NaN
   C2            30.070     0.32976     -127.690      549.58      706.62     0.09900     -0.06280     0.27924     0.27924      111.00           NaN
   C3            44.097     0.50977      -43.989      665.69      616.12     0.15200     -0.06381     0.27630     0.27630      151.00           NaN
   C4            57.526     0.59498       28.693      767.19      564.18     0.18391     -0.05763     0.27699     0.27699      173.06           NaN
   C5            71.459     0.64541       93.829      848.76      505.26     0.22824     -0.03281     0.27152     0.27152      206.50       0.25204
   C6-C7         90.253     0.69744      171.286      944.04      449.13     0.27717     -0.00464     0.26553     0.26610      251.61       0.37509
   C8-C10       125.094     0.76672      293.137     1088.07      380.94     0.35815      0.02863     0.25645     0.26618      335.23       0.79013
   C11-C14      173.081     0.82562      429.111     1236.31      319.06     0.47254      0.05163     0.24635     0.27069      450.39       1.83008
   C15-C19      234.994     0.87160      567.216     1374.77      266.30     0.60936      0.06440     0.23575     0.27888      598.98       4.40164
   C20-C29      333.292     0.91355      730.132     1525.71      214.06     0.81046      0.06552     0.22151     0.29364      834.90      12.83502
   C30+         613.585     0.96424     1078.378     1810.30      122.69     1.40716      0.19696     0.17789     0.31292     1507.60     649.06434
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_002_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle
set ylabel "Boiling Temperature (F)"
set output "Figures/Table_002_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_002_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:9 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_002_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:10 with points notitle
set ylabel "Liquid Viscosity (cp)"
set logscale y
set output "Figures/Table_002_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 2:12 with points notitle
unset logscale y

set title "CVD for Generation of Oil Rim Black Oil Tables"
show title

$Expt << END
#            Pres                                Liq Sat (%)
#  Stg      (psia)      Eq Liq      Eq Vap      Expt    Calc
#------   ---------   ---------   ---------   ----------------
     1     3750.00     Oil_Rim     Oil_Rim        NaN  100.00
     2     3500.00     Oil_Rim     Oil_Rim        NaN   98.54
     3     3250.00     Oil_Rim     Oil_Rim        NaN   97.12
     4     3000.00     Oil_Rim     Oil_Rim        NaN   95.73
     5     2750.00     Oil_Rim     Oil_Rim        NaN   94.36
     6     2500.00     Oil_Rim     Oil_Rim        NaN   93.00
     7     2000.00     Oil_Rim     Oil_Rim        NaN   90.31
     8     1500.00     Oil_Rim     Oil_Rim        NaN   87.62
     9     1200.00     Oil_Rim     Oil_Rim        NaN   86.00
    10     1000.00     Oil_Rim     Oil_Rim        NaN   84.91
    11      900.00     Oil_Rim     Oil_Rim        NaN   84.36
    12      800.00     Oil_Rim     Oil_Rim        NaN   83.81
    13      700.00     Oil_Rim     Oil_Rim        NaN   83.25
    14      600.00     Oil_Rim     Oil_Rim        NaN   82.68
    15      500.00     Oil_Rim     Oil_Rim        NaN   82.09
    16      400.00     Oil_Rim     Oil_Rim        NaN   81.48
    17      300.00     Oil_Rim     Oil_Rim        NaN   80.83
    18      200.00     Oil_Rim     Oil_Rim        NaN   80.10
    19      100.00     Oil_Rim     Oil_Rim        NaN   79.12
    20       50.00     Oil_Rim     Oil_Rim        NaN   78.38
    21       14.70     Oil_Rim     Oil_Rim        NaN   76.91
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_001_LS_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CVD of Gas for Generation of Gas Cap Tables"
show title

$Expt << END
#            Pres                                   Liq Sat (%)
#  Stg      (psia)      Eq Vap       Eq Liq        Expt     Calc
#------   ---------   ----------   ----------   ------------------
     1     3750.00     Gas_Cap1     Gas_Cap1         NaN  0.00000
     2     3500.00     Gas_Cap1     Gas_Cap1         NaN  0.02860
     3     3250.00     Gas_Cap1     Gas_Cap1         NaN  0.25265
     4     3000.00     Gas_Cap1     Gas_Cap1         NaN  0.60298
     5     2750.00     Gas_Cap1     Gas_Cap1         NaN  0.99594
     6     2500.00     Gas_Cap1     Gas_Cap1         NaN  1.36301
     7     2000.00     Gas_Cap1     Gas_Cap1         NaN  1.91332
     8     1500.00     Gas_Cap1     Gas_Cap1         NaN  2.13281
     9     1200.00     Gas_Cap1     Gas_Cap1         NaN  2.12300
    10     1000.00     Gas_Cap1     Gas_Cap1         NaN  2.07294
    11      900.00     Gas_Cap1     Gas_Cap1         NaN  2.03726
    12      800.00     Gas_Cap1     Gas_Cap1         NaN  1.99543
    13      700.00     Gas_Cap1     Gas_Cap1         NaN  1.94766
    14      600.00     Gas_Cap1     Gas_Cap1         NaN  1.89394
    15      500.00     Gas_Cap1     Gas_Cap1         NaN  1.83383
    16      400.00     Gas_Cap1     Gas_Cap1         NaN  1.76617
    17      300.00     Gas_Cap1     Gas_Cap1         NaN  1.68826
    18      200.00     Gas_Cap1     Gas_Cap1         NaN  1.59321
    19      100.00     Gas_Cap1     Gas_Cap1         NaN  1.45585
    20       50.00     Gas_Cap1     Gas_Cap1         NaN  1.35156
    21       14.70     Gas_Cap1     Gas_Cap1         NaN  1.17611
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_002_LS_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CVD of Gas for Generation of Gas Cap Gas Tables"
show title

$Expt << END
#            Pres                      Liq Sat (%)
#  Stg      (psia)      Eq Vap        Expt     Calc
#------   ---------   ----------   ------------------
     1     3750.00     Gas_Cap2         NaN  0.00000
     2     3500.00     Gas_Cap2         NaN  0.02860
     3     3250.00     Gas_Cap2         NaN  0.25265
     4     3000.00     Gas_Cap2         NaN  0.60298
     5     2750.00     Gas_Cap2         NaN  0.99594
     6     2500.00     Gas_Cap2         NaN  1.36301
     7     2000.00     Gas_Cap2         NaN  1.91332
     8     1500.00     Gas_Cap2         NaN  2.13281
     9     1200.00     Gas_Cap2         NaN  2.12300
    10     1000.00     Gas_Cap2         NaN  2.07294
    11      900.00     Gas_Cap2         NaN  2.03726
    12      800.00     Gas_Cap2         NaN  1.99543
    13      700.00     Gas_Cap2         NaN  1.94766
    14      600.00     Gas_Cap2         NaN  1.89394
    15      500.00     Gas_Cap2         NaN  1.83383
    16      400.00     Gas_Cap2         NaN  1.76617
    17      300.00     Gas_Cap2         NaN  1.68826
    18      200.00     Gas_Cap2         NaN  1.59321
    19      100.00     Gas_Cap2         NaN  1.45585
    20       50.00     Gas_Cap2         NaN  1.35156
    21       14.70     Gas_Cap2         NaN  1.17611
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_003_LS_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "CVD of Condensate for Generation of Gas Cap Oil Tables"
show title

$Expt << END
#            Pres                     Liq Sat (%)
#  Stg      (psia)      Eq Liq       Expt    Calc
#------   ---------   ----------   ----------------
     1     3750.00     Gas_Cap2        NaN  100.00
     2     3500.00     Gas_Cap2        NaN   98.54
     3     3250.00     Gas_Cap2        NaN   97.12
     4     3000.00     Gas_Cap2        NaN   95.73
     5     2750.00     Gas_Cap2        NaN   94.36
     6     2500.00     Gas_Cap2        NaN   93.00
     7     2000.00     Gas_Cap2        NaN   90.31
     8     1500.00     Gas_Cap2        NaN   87.62
     9     1200.00     Gas_Cap2        NaN   86.00
    10     1000.00     Gas_Cap2        NaN   84.91
    11      900.00     Gas_Cap2        NaN   84.36
    12      800.00     Gas_Cap2        NaN   83.81
    13      700.00     Gas_Cap2        NaN   83.25
    14      600.00     Gas_Cap2        NaN   82.68
    15      500.00     Gas_Cap2        NaN   82.09
    16      400.00     Gas_Cap2        NaN   81.48
    17      300.00     Gas_Cap2        NaN   80.83
    18      200.00     Gas_Cap2        NaN   80.10
    19      100.00     Gas_Cap2        NaN   79.12
    20       50.00     Gas_Cap2        NaN   78.38
    21       14.70     Gas_Cap2        NaN   76.91
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_004_LS_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "Single-Stage Black Oil Tables for Oil Rim"
show title

$BOT_BP << END
#    Psat        EOS Deno      BO Deno           Rs             Bo          1/Bo         Viso
#   (psia)      (lbm/ft3)     (lbm/ft3)      (Mscf/stb)      (rb/stb)     (stb/rb)       (cp)
#-----------   -----------   -----------   -------------   -----------   ----------   ---------
     14.696      52.3020       52.7286       0.0000000       1.05753      0.945597     3.06858
     50.000      51.9722       52.6347       0.0023991       1.05989      0.943491     2.89926
    100.000      51.7839       52.4194       0.0140442       1.06656      0.937589     2.81635
    200.000      51.5202       52.0334       0.0368271       1.07904      0.926749     2.70403
    300.000      51.3099       51.7140       0.0574536       1.08986      0.917545     2.61523
    400.000      51.1180       51.4322       0.0768583       1.09977      0.909281     2.53403
    500.000      50.9356       51.1743       0.0955505       1.10912      0.901615     2.45691
    600.000      50.7591       50.9333       0.1138007       1.11811      0.894370     2.38270
    700.000      50.5868       50.7050       0.1317670       1.12683      0.887442     2.31095
    800.000      50.4177       50.4870       0.1495486       1.13537      0.880767     2.24149
    900.000      50.2513       50.2773       0.1672117       1.14377      0.874301     2.17424
   1000.000      50.0872       50.0748       0.1848015       1.15206      0.868012     2.10918
   1200.000      49.7646       49.6861       0.2200076       1.16846      0.855828     1.98501
   1500.000      49.2950       49.1396       0.2729281       1.19269      0.838444     1.81456
   2000.000      48.5503       48.3076       0.3618824       1.23243      0.811408     1.57074
   2500.000      47.8530       47.5590       0.4519089       1.27156      0.786433     1.37161
   2750.000      47.5206       47.2104       0.4974519       1.29101      0.774586     1.28597
   3000.000      47.1985       46.8766       0.5434308       1.31043      0.763108     1.20831
   3250.000      46.8861       46.5562       0.5898975       1.32986      0.751961     1.13770
   3500.000      46.5827       46.2478       0.6369131       1.34933      0.741111     1.07329
   3750.000      46.2875       45.9500       0.6845497       1.36888      0.730524     1.01430
   4000.000      46.0016       45.6634       0.7327313       1.38847      0.720215     0.96050
   4500.000      45.4608       45.1249       0.8303868       1.42761      0.700472     0.86713
   5000.000      44.9546       44.6256       0.9300975       1.46688      0.681718     0.78869
   5500.000      44.4801       44.1616       1.0318900       1.50633      0.663867     0.72217
   6000.000      44.0340       43.7292       1.1358708       1.54602      0.646824     0.66517
   6500.000      43.6118       43.3237       1.2423382       1.58611      0.630473     0.61565
   7000.000      43.2075       42.9393       1.3519626       1.62693      0.614654     0.57184
   7500.000      42.8127       42.5679       1.4660502       1.66907      0.599136     0.53210
   8000.000      42.4155       42.1984       1.5869217       1.71355      0.583584     0.49487
   8500.000      41.9989       41.8148       1.7185856       1.76210      0.567504     0.45857
   9000.000      41.5354       41.3913       1.8684660       1.81789      0.550088     0.42129
   9500.000      40.9665       40.8732       2.0535836       1.88816      0.529617     0.37977
  10000.000      40.0623       40.0469       2.3430792       2.00250      0.499377     0.32263
  10134.449      39.2301       39.2790       2.5954782       2.10864      0.474239     0.27850
END

$BOT_DP << END
#    Psat        EOS Deng       BO Deng          Rv             Bg           1/Bg         Visg
#   (psia)       (lbm/ft3)     (lbm/ft3)     (stb/Mscf)     (rb/Mscf)     (Mscf/rb)       (cp)
#-----------   ------------   -----------   ------------   -----------   -----------   ----------
     14.696       0.11885       0.086960     0.23833713     272.73646     0.0036665     0.010058
     50.000       0.29100       0.178705     0.02056052      64.76337     0.0154408     0.011809
    100.000       0.49153       0.337295     0.00463460      31.67998     0.0315657     0.012628
    200.000       0.86219       0.671476     0.00083970      15.59831     0.0641095     0.013199
    300.000       1.21509       1.016045     0.00041446      10.28514     0.0972276     0.013459
    400.000       1.56282       1.367549     0.00030007       7.63687     0.1309437     0.013638
    500.000       1.90998       1.725311     0.00026185       6.05205     0.1652334     0.013793
    600.000       2.25875       2.088967     0.00025570       4.99832     0.2000673     0.013942
    700.000       2.61032       2.458192     0.00026830       4.24785     0.2354134     0.014095
    800.000       2.96536       2.832663     0.00029485       3.68681     0.2712368     0.014257
    900.000       3.32428       3.212041     0.00033374       3.25204     0.3074997     0.014432
   1000.000       3.68728       3.595970     0.00038493       2.90562     0.3441605     0.014621
   1200.000       4.42758       4.376317     0.00052852       2.38935     0.4185246     0.015049
   1500.000       5.56964       5.571873     0.00087767       1.88016     0.5318700     0.015831
   2000.000       7.54217       7.606666     0.00204213       1.38575     0.7216310     0.017553
   2500.000       9.56502       9.661626     0.00436357       1.10441     0.9054618     0.019817
   2750.000      10.58415      10.688020     0.00606790       1.00724     0.9928100     0.021142
   3000.000      11.60462      11.710442     0.00816533       0.92929     1.0760920     0.022585
   3250.000      12.62422      12.727429     0.01067527       0.86603     1.1546940     0.024135
   3500.000      13.64172      13.738580     0.01362109       0.81425     1.2281277     0.025785
   3750.000      14.65684      14.744525     0.01703213       0.77160     1.2960155     0.027528
   4000.000      15.66912      15.745986     0.02093576       0.73635     1.3580579     0.029362
   4500.000      17.68369      17.739619     0.03033669       0.68314     1.4638214     0.033309
   5000.000      19.69183      19.734653     0.04214934       0.64746     1.5444964     0.037715
   5500.000      21.70049      21.744643     0.05675396       0.62506     1.5998367     0.042773
   6000.000      23.71287      23.776072     0.07456071       0.61342     1.6302028     0.048804
   6500.000      25.72224      25.821193     0.09591211       0.61095     1.6368080     0.056264
   7000.000      27.70672      27.852007     0.12090881       0.61644     1.6222071     0.065748
   7500.000      29.63039      29.822258     0.14924703       0.62871     1.5905707     0.077947
   8000.000      31.45644      31.683798     0.18028603       0.64639     1.5470446     0.093618
   8500.000      33.16696      33.410308     0.21347250       0.66838     1.4961562     0.113669
   9000.000      34.77749      35.012836     0.24898863       0.69435     1.4401925     0.139550
   9500.000      36.35282      36.552541     0.28883679       0.72589     1.3776131     0.174491
  10000.000      38.13689      38.256852     0.34307232       0.77261     1.2943182     0.231180
  10134.449      39.18674      39.238838     0.38339636       0.81058     1.2336894     0.276406
END

set output "Figures/BOT_001_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs (Mscf/stb)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_001_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Bo (rb/stb)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_001_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rv (stb/Mscf)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_001_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "1/Bg (Mscf/rb)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_001_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_001_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Density (lbm/ft3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_001_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs and 1/Rv (Mscf/stb)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set title "Single-Stage Black Oil Tables for Gas Cap 1"
show title

$BOT_BP << END
#   Psat        EOS Deno      BO Deno           Rs             Bo          1/Bo         Viso
#  (psia)      (lbm/ft3)     (lbm/ft3)      (Mscf/stb)      (rb/stb)     (stb/rb)       (cp)
#----------   -----------   -----------   -------------   -----------   ----------   ---------
    14.696      47.3834       49.7038       0.0000000       1.06684      0.937345     0.60460
    50.000      46.7387       49.5549       0.0046890       1.07106      0.933654     0.54448
   100.000      46.2694       49.3448       0.0161170       1.07810      0.927561     0.50772
   200.000      45.5769       48.8801       0.0440498       1.09446      0.913695     0.45951
   300.000      45.0277       48.3772       0.0761645       1.11293      0.898528     0.42524
   400.000      44.5402       47.8519       0.1112024       1.13298      0.882629     0.39711
   500.000      44.0901       47.3159       0.1485337       1.15425      0.866364     0.37285
   600.000      43.6663       46.7775       0.1877719       1.17651      0.849975     0.35142
   700.000      43.2635       46.2424       0.2286494       1.19957      0.833631     0.33226
   800.000      42.8782       45.7149       0.2709621       1.22331      0.817454     0.31499
   900.000      42.5087       45.1982       0.3145420       1.24761      0.801536     0.29938
  1000.000      42.1537       44.6947       0.3592411       1.27235      0.785945     0.28521
  1200.000      41.4854       43.7337       0.4515029       1.32287      0.755933     0.26066
  1500.000      40.5917       42.4314       0.5946671       1.39955      0.714515     0.23193
  2000.000      39.4398       40.7030       0.8334875       1.52172      0.657153     0.20153
  2500.000      38.8196       39.6140       1.0453121       1.62073      0.617007     0.18968
  2750.000      38.7750       39.3512       1.1266913       1.65366      0.604718     0.19129
  3000.000      39.0042       39.3447       1.1765717       1.66749      0.599702     0.20108
  3250.000      39.6574       39.7012       1.1750629       1.65211      0.605286     0.22659
  3500.000      41.2848       40.8022       1.0659295       1.57893      0.633338     0.30883
  3750.000      46.2875       44.0841       0.6845497       1.36888      0.730524     1.01430
  4000.000      48.9073       45.5765       0.5350035       1.28897      0.775812     2.18068
  4500.000      50.8061       46.5408       0.4555383       1.24401      0.803853     4.05913
  5000.000      51.5205       46.8669       0.4405533       1.23193      0.811732     5.23611
  5500.000      51.8609       47.0083       0.4436563       1.22893      0.813714     5.96588
  6000.000      52.0385       47.0743       0.4541176       1.22959      0.813281     6.42654
  6500.000      52.1334       47.1045       0.4680786       1.23197      0.811710     6.72229
  7000.000      52.1827       47.1166       0.4838001       1.23522      0.809573     6.91460
  7500.000      52.2056       47.1195       0.5003813       1.23890      0.807164     7.04086
  8000.000      52.2130       47.1182       0.5173095       1.24278      0.804646     7.12455
END

$BOT_DP << END
#   Psat        EOS Deng      BO Deng          Rv             Bg           1/Bg          Visg
#  (psia)      (lbm/ft3)     (lbm/ft3)     (stb/Mscf)     (rb/Mscf)     (Mscf/rb)        (cp)
#----------   -----------   -----------   ------------   -----------   -----------   -----------
    14.696      0.071845      0.072236     0.13249848     245.28785     0.0040768     0.0116745
    50.000      0.194223      0.188602     0.03385864      66.21477     0.0151024     0.0124843
   100.000      0.361168      0.352961     0.01356582      32.33265     0.0309285     0.0127809
   200.000      0.694962      0.689583     0.00445526      15.84881     0.0630962     0.0130285
   300.000      1.032606      1.036163     0.00202823      10.42344     0.0959377     0.0131912
   400.000      1.376343      1.392378     0.00121096       7.72566     0.1294388     0.0133359
   500.000      1.726970      1.757224     0.00091126       6.11257     0.1635973     0.0134801
   600.000      2.084856      2.129927     0.00080195       5.04024     0.1984031     0.0136311
   700.000      2.450170      2.510051     0.00078203       4.27653     0.2338347     0.0137930
   800.000      2.822964      2.897292     0.00081735       3.70559     0.2698627     0.0139685
   900.000      3.203202      3.291394     0.00089633       3.26316     0.3064511     0.0141597
  1000.000      3.590775      3.692116     0.00101664       2.91073     0.3435569     0.0143685
  1200.000      4.387395      4.512535     0.00139183       2.38594     0.4191223     0.0148448
  1500.000      5.630718      5.786669     0.00236522       1.86951     0.5348990     0.0157254
  2000.000      7.796742      7.999544     0.00524977       1.37148     0.7291400     0.0176896
  2500.000      9.995728     10.248414     0.00943309       1.09217     0.9156069     0.0202584
  2750.000     11.068486     11.347553     0.01175080       0.99721     1.0027947     0.0217164
  3000.000     12.095703     12.401214     0.01395740       0.92192     1.0846920     0.0232338
  3250.000     13.052346     13.382948     0.01577019       0.86147     1.1608012     0.0247517
  3500.000     13.913454     14.266348     0.01688787       0.81228     1.2310964     0.0262050
  3750.000     14.656843     15.028565     0.01703213       0.77160     1.2960155     0.0275280
  4000.000     15.343813     15.732870     0.01706284       0.73716     1.3565620     0.0288002
  4500.000     16.588334     17.008623     0.01712644       0.68206     1.4661370     0.0312264
  5000.000     17.685984     18.133505     0.01720563       0.63999     1.5625359     0.0335074
  5500.000     18.662839     19.134205     0.01730711       0.60680     1.6480005     0.0356668
  6000.000     19.539649     20.031970     0.01743104       0.57993     1.7243476     0.0377296
  6500.000     20.332803     20.843602     0.01757524       0.55771     1.7930326     0.0397189
  7000.000     21.055248     21.582394     0.01773638       0.53902     1.8552222     0.0416538
  7500.000     21.717285     22.258939     0.01791072       0.52305     1.9118587     0.0435502
  8000.000     22.327184     22.881757     0.01809449       0.50924     1.9637101     0.0454207
END

set output "Figures/BOT_002_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs (Mscf/stb)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_002_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Bo (rb/stb)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_002_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rv (stb/Mscf)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_002_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "1/Bg (Mscf/rb)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_002_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_002_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Density (lbm/ft3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_002_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs and 1/Rv (Mscf/stb)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set title "Single-Stage Black Oil Tables for Gas Cap 2"
show title

$BOT_BP << END
#   Psat        EOS Deno      BO Deno           Rs             Bo          1/Bo         Viso
#  (psia)      (lbm/ft3)     (lbm/ft3)      (Mscf/stb)      (rb/stb)     (stb/rb)       (cp)
#----------   -----------   -----------   -------------   -----------   ----------   ---------
    14.696      52.3020       52.7365       0.0000000       1.05753      0.945597     3.06858
    50.000      51.9722       52.6427       0.0023991       1.05989      0.943491     2.89926
   100.000      51.7839       52.4274       0.0140442       1.06656      0.937589     2.81635
   200.000      51.5202       52.0416       0.0368271       1.07904      0.926749     2.70403
   300.000      51.3099       51.7223       0.0574536       1.08986      0.917545     2.61523
   400.000      51.1180       51.4406       0.0768583       1.09977      0.909281     2.53403
   500.000      50.9356       51.1828       0.0955505       1.10912      0.901615     2.45691
   600.000      50.7591       50.9419       0.1138007       1.11811      0.894370     2.38270
   700.000      50.5868       50.7137       0.1317670       1.12683      0.887442     2.31095
   800.000      50.4177       50.4957       0.1495486       1.13537      0.880767     2.24149
   900.000      50.2513       50.2861       0.1672117       1.14377      0.874301     2.17424
  1000.000      50.0872       50.0838       0.1848015       1.15206      0.868012     2.10918
  1200.000      49.7646       49.6952       0.2200076       1.16846      0.855828     1.98501
  1500.000      49.2950       49.1489       0.2729281       1.19269      0.838444     1.81456
  2000.000      48.5503       48.3174       0.3618824       1.23243      0.811408     1.57074
  2500.000      47.8530       47.5691       0.4519089       1.27156      0.786433     1.37161
  2750.000      47.5206       47.2207       0.4974519       1.29101      0.774586     1.28597
  3000.000      47.1985       46.8872       0.5434308       1.31043      0.763108     1.20831
  3250.000      46.8861       46.5669       0.5898975       1.32986      0.751961     1.13770
  3500.000      46.5827       46.2587       0.6369131       1.34933      0.741111     1.07329
  3750.000      46.2875       45.9611       0.6845497       1.36888      0.730524     1.01430
  4000.000      46.0016       45.6747       0.7327313       1.38847      0.720215     0.96050
  4500.000      45.4608       45.1365       0.8303868       1.42761      0.700472     0.86713
  5000.000      44.9546       44.6376       0.9300975       1.46688      0.681718     0.78869
  5500.000      44.4801       44.1740       1.0318900       1.50633      0.663867     0.72217
  6000.000      44.0340       43.7419       1.1358708       1.54602      0.646824     0.66517
  6500.000      43.6118       43.3367       1.2423382       1.58611      0.630473     0.61565
  7000.000      43.2075       42.9526       1.3519626       1.62693      0.614654     0.57184
  7500.000      42.8127       42.5816       1.4660502       1.66907      0.599136     0.53210
  8000.000      42.4155       42.2125       1.5869217       1.71355      0.583584     0.49487
END

$BOT_DP << END
#   Psat        EOS Deng      BO Deng          Rv             Bg           1/Bg          Visg
#  (psia)      (lbm/ft3)     (lbm/ft3)     (stb/Mscf)     (rb/Mscf)     (Mscf/rb)        (cp)
#----------   -----------   -----------   ------------   -----------   -----------   -----------
    14.696      0.071845      0.072676     0.13249848     245.28785     0.0040768     0.0116745
    50.000      0.194223      0.186140     0.03385864      66.21477     0.0151024     0.0124843
   100.000      0.361168      0.346198     0.01356582      32.33265     0.0309285     0.0127809
   200.000      0.694962      0.674207     0.00445526      15.84881     0.0630962     0.0130285
   300.000      1.032606      1.012145     0.00202823      10.42344     0.0959377     0.0131912
   400.000      1.376343      1.359683     0.00121096       7.72566     0.1294388     0.0133359
   500.000      1.726970      1.715766     0.00091126       6.11257     0.1635973     0.0134801
   600.000      2.084856      2.079589     0.00080195       5.04024     0.1984031     0.0136311
   700.000      2.450170      2.450711     0.00078203       4.27653     0.2338347     0.0137930
   800.000      2.822964      2.828835     0.00081735       3.70559     0.2698627     0.0139685
   900.000      3.203202      3.213722     0.00089633       3.26316     0.3064511     0.0141597
  1000.000      3.590775      3.605153     0.00101664       2.91073     0.3435569     0.0143685
  1200.000      4.387395      4.406876     0.00139183       2.38594     0.4191223     0.0148448
  1500.000      5.630718      5.653253     0.00236522       1.86951     0.5348990     0.0157254
  2000.000      7.796742      7.823451     0.00524977       1.37148     0.7291400     0.0176896
  2500.000      9.995728     10.037801     0.00943309       1.09217     0.9156069     0.0202584
  2750.000     11.068486     11.123263     0.01175080       0.99721     1.0027947     0.0217164
  3000.000     12.095703     12.165175     0.01395740       0.92192     1.0846920     0.0232338
  3250.000     13.052346     13.136122     0.01577019       0.86147     1.1608012     0.0247517
  3500.000     13.913454     14.008352     0.01688787       0.81228     1.2310964     0.0262050
  3750.000     14.656843     14.757477     0.01703213       0.77160     1.2960155     0.0275280
  4000.000     15.343813     15.449232     0.01706284       0.73716     1.3565620     0.0288002
  4500.000     16.588334     16.702330     0.01712644       0.68206     1.4661370     0.0312264
  5000.000     17.685984     17.807413     0.01720563       0.63999     1.5625359     0.0335074
  5500.000     18.662839     18.790736     0.01730711       0.60680     1.6480005     0.0356668
  6000.000     19.539649     19.673175     0.01743104       0.57993     1.7243476     0.0377296
  6500.000     20.332803     20.471225     0.01757524       0.55771     1.7930326     0.0397189
  7000.000     21.055248     21.197922     0.01773638       0.53902     1.8552222     0.0416538
  7500.000     21.717285     21.863645     0.01791072       0.52305     1.9118587     0.0435502
  8000.000     22.327184     22.476733     0.01809449       0.50924     1.9637101     0.0454207
END

set output "Figures/BOT_003_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs (Mscf/stb)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_003_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Bo (rb/stb)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_003_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rv (stb/Mscf)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_003_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "1/Bg (Mscf/rb)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_003_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_003_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Density (lbm/ft3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_003_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs and 1/Rv (Mscf/stb)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set title "Three-Stage Black Oil Tables for Oil Rim"
show title

$BOT_BP << END
#    Psat        EOS Deno      BO Deno           Rs             Bo          1/Bo         Viso
#   (psia)      (lbm/ft3)     (lbm/ft3)      (Mscf/stb)      (rb/stb)     (stb/rb)       (cp)
#-----------   -----------   -----------   -------------   -----------   ----------   ---------
     14.696      52.3020       52.4491      4.79487e-04      1.05783      0.945330     3.06858
     50.000      51.9722       52.3658      2.39334e-03      1.05989      0.943496     2.89926
    100.000      51.7839       52.1795      1.27145e-02      1.06570      0.938354     2.81635
    200.000      51.5202       51.8734      3.19881e-02      1.07578      0.929555     2.70403
    300.000      51.3099       51.6060      5.03247e-02      1.08499      0.921667     2.61523
    400.000      51.1180       51.3606      6.80695e-02      1.09371      0.914320     2.53403
    500.000      50.9356       51.1294      8.54785e-02      1.10214      0.907330     2.45691
    600.000      50.7591       50.9088      1.02692e-01      1.11037      0.900601     2.38270
    700.000      50.5868       50.6964      1.19793e-01      1.11847      0.894078     2.31095
    800.000      50.4177       50.4909      1.36835e-01      1.12647      0.887726     2.24149
    900.000      50.2513       50.2914      1.53850e-01      1.13440      0.881520     2.17424
   1000.000      50.0872       50.0971      1.70865e-01      1.14228      0.875445     2.10918
   1200.000      49.7646       49.7207      2.05067e-01      1.15796      0.863588     1.98501
   1500.000      49.2950       49.1853      2.56732e-01      1.18131      0.846521     1.81456
   2000.000      48.5503       48.3613      3.43947e-01      1.21988      0.819756     1.57074
   2500.000      47.8530       47.6140      4.32420e-01      1.25802      0.794899     1.37161
   2750.000      47.5206       47.2651      4.77198e-01      1.27700      0.783087     1.28597
   3000.000      47.1985       46.9306      5.22400e-01      1.29595      0.771635     1.20831
   3250.000      46.8861       46.6093      5.68069e-01      1.31490      0.760512     1.13770
   3500.000      46.5827       46.2999      6.14256e-01      1.33389      0.749687     1.07329
   3750.000      46.2875       46.0014      6.61025e-01      1.35294      0.739129     1.01430
   4000.000      46.0016       45.7140      7.08305e-01      1.37203      0.728849     0.96050
   4500.000      45.4608       45.1739      8.04066e-01      1.41011      0.709166     0.86713
   5000.000      44.9546       44.6736      9.01713e-01      1.44825      0.690487     0.78869
   5500.000      44.4801       44.2093      1.00125e+00      1.48649      0.672727     0.72217
   6000.000      44.0340       43.7773      1.10275e+00      1.52487      0.655794     0.66517
   6500.000      43.6118       43.3730      1.20649e+00      1.56354      0.639574     0.61565
   7000.000      43.2075       42.9908      1.31310e+00      1.60280      0.623908     0.57184
   7500.000      42.8127       42.6224      1.42381e+00      1.64321      0.608564     0.53210
   8000.000      42.4155       42.2569      1.54083e+00      1.68575      0.593208     0.49487
   8500.000      41.9989       41.8782      1.66800e+00      1.73205      0.577351     0.45857
   9000.000      41.5354       41.4606      1.81241e+00      1.78511      0.560188     0.42129
   9500.000      40.9665       40.9500      1.99027e+00      1.85179      0.540019     0.37977
  10000.000      40.0623       40.1348      2.26740e+00      1.96001      0.510200     0.32263
  10134.449      39.2301       39.3757      2.50805e+00      2.06030      0.485367     0.27850
END

$BOT_DP << END
#    Psat        EOS Deng        BO Deng          Rv             Bg           1/Bg         Visg
#   (psia)       (lbm/ft3)      (lbm/ft3)     (stb/Mscf)     (rb/Mscf)     (Mscf/rb)       (cp)
#-----------   ------------   ------------   ------------   -----------   -----------   ----------
     14.696       0.11885        0.10113      0.37999690     309.59298     0.0032300     0.010058
     50.000       0.29100        0.18805      0.03987379      66.14343     0.0151187     0.011809
    100.000       0.49153        0.33639      0.00852315      31.80613     0.0314405     0.012628
    200.000       0.86219        0.66038      0.00144669      15.60722     0.0640729     0.013199
    300.000       1.21509        0.99716      0.00055828      10.28654     0.0972144     0.013459
    400.000       1.56282        1.34157      0.00035211       7.63727     0.1309368     0.013638
    500.000       1.90998        1.69230      0.00028471       6.05221     0.1652289     0.013793
    600.000       2.25875        2.04890      0.00026757       4.99841     0.2000638     0.013942
    700.000       2.61032        2.41100      0.00027682       4.24791     0.2354099     0.014095
    800.000       2.96536        2.77831      0.00030439       3.68687     0.2712326     0.014257
    900.000       3.32428        3.15047      0.00034763       3.25210     0.3074936     0.014432
   1000.000       3.68728        3.52717      0.00040621       2.90570     0.3441513     0.014621
   1200.000       4.42758        4.29312      0.00057463       2.38946     0.4185042     0.015049
   1500.000       5.56964        5.46781      0.00099358       1.88037     0.5318107     0.015831
   2000.000       7.54217        7.47299      0.00239175       1.38620     0.7213964     0.017553
   2500.000       9.56502        9.50736      0.00505595       1.10513     0.9048718     0.019817
   2750.000      10.58415       10.52667      0.00694749       1.00809     0.9919778     0.021142
   3000.000      11.60462       11.54423      0.00924217       0.93026     1.0749720     0.022585
   3250.000      12.62422       12.55887      0.01196436       0.86713     1.1532350     0.024135
   3500.000      13.64172       13.57047      0.01514249       0.81548     1.2262724     0.025785
   3750.000      14.65684       14.57988      0.01880985       0.77298     1.2937018     0.027528
   4000.000      15.66912       15.58788      0.02299515       0.73789     1.3552229     0.029362
   4500.000      17.68369       17.60333      0.03303383       0.68504     1.4597671     0.033309
   5000.000      19.69183       19.63029      0.04558011       0.64976     1.5390225     0.037715
   5500.000      21.70049       21.67918      0.06100180       0.62782     1.5928166     0.042773
   6000.000      23.71287       23.75260      0.07969392       0.61667     1.6216052     0.048804
   6500.000      25.72224       25.83866      0.10198119       0.61474     1.6267076     0.056264
   7000.000      27.70672       27.90554      0.12794119       0.62082     1.6107823     0.065748
   7500.000      29.63039       29.90418      0.15724145       0.63368     1.5780802     0.077947
   8000.000      31.45644       31.78527      0.18921372       0.65198     1.5337823     0.093618
   8500.000      33.16696       33.52299      0.22329031       0.67458     1.4824036     0.113669
   9000.000      34.77749       35.12965      0.25966262       0.70117     1.4261919     0.139550
   9500.000      36.35282       36.66746      0.30038031       0.73337     1.3635745     0.174491
  10000.000      38.13689       38.36268      0.35569442       0.78095     1.2804900     0.231180
  10134.449      39.18674       39.33595      0.39679068       0.81959     1.2201243     0.276406
END

set output "Figures/BOT_004_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs (Mscf/stb)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_004_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Bo (rb/stb)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_004_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rv (stb/Mscf)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_004_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "1/Bg (Mscf/rb)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_004_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_004_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Density (lbm/ft3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_004_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs and 1/Rv (Mscf/stb)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set title "Three-Stage Black Oil Tables for Gas Cap 1"
show title

$BOT_BP << END
#   Psat        EOS Deno      BO Deno           Rs             Bo          1/Bo         Viso
#  (psia)      (lbm/ft3)     (lbm/ft3)      (Mscf/stb)      (rb/stb)     (stb/rb)       (cp)
#----------   -----------   -----------   -------------   -----------   ----------   ---------
    14.696      47.3834       49.3542       0.0010226       1.06732      0.936923     0.60460
    50.000      46.7387       49.2169       0.0047236       1.07110      0.933621     0.54448
   100.000      46.2694       49.0236       0.0153009       1.07761      0.927980     0.50772
   200.000      45.5769       48.6234       0.0401011       1.09189      0.915844     0.45951
   300.000      45.0277       48.1979       0.0685678       1.10779      0.902697     0.42524
   400.000      44.5402       47.7520       0.0997734       1.12507      0.888836     0.39711
   500.000      44.0901       47.2926       0.1332230       1.14350      0.874510     0.37285
   600.000      43.6663       46.8254       0.1686028       1.16292      0.859905     0.35142
   700.000      43.2635       46.3551       0.2056886       1.18320      0.845164     0.33226
   800.000      42.8782       45.8855       0.2443048       1.20424      0.830400     0.31499
   900.000      42.5087       45.4196       0.2843038       1.22593      0.815706     0.29938
  1000.000      42.1537       44.9600       0.3255531       1.24819      0.801157     0.28521
  1200.000      41.4854       44.0676       0.4113409       1.29412      0.772728     0.26066
  1500.000      40.5917       42.8255       0.5460640       1.36501      0.732593     0.23193
  2000.000      39.4398       41.1140       0.7748648       1.48086      0.675285     0.20153
  2500.000      38.8196       39.9808       0.9824429       1.57790      0.633755     0.18968
  2750.000      38.7750       39.6843       1.0641109       1.61151      0.620536     0.19129
  3000.000      39.0042       39.6384       1.1163470       1.62735      0.614496     0.20108
  3250.000      39.6574       39.9486       1.1199291       1.61567      0.618939     0.22659
  3500.000      41.2848       40.9826       1.0210331       1.54931      0.645448     0.30883
  3750.000      46.2875       44.1087       0.6610252       1.35294      0.739129     1.01430
  4000.000      48.9073       45.5183       0.5189566       1.27794      0.782506     2.18068
  4500.000      50.8061       46.4204       0.4439093       1.23596      0.809085     4.05913
  5000.000      51.5205       46.7207       0.4304794       1.22497      0.816344     5.23611
  5500.000      51.8609       46.8478       0.4343490       1.22252      0.817980     5.96588
  6000.000      52.0385       46.9049       0.4452441       1.22350      0.817327     6.42654
  6500.000      52.1334       46.9289       0.4594667       1.22609      0.815602     6.72229
  7000.000      52.1827       46.9366       0.4753493       1.22948      0.813355     6.91460
  7500.000      52.2056       46.9362       0.4920284       1.23325      0.810863     7.04086
  8000.000      52.2130       46.9323       0.5090125       1.23720      0.808280     7.12455
END

$BOT_DP << END
#   Psat        EOS Deng      BO Deng           Rv             Bg           1/Bg          Visg
#  (psia)      (lbm/ft3)     (lbm/ft3)      (stb/Mscf)     (rb/Mscf)     (Mscf/rb)        (cp)
#----------   -----------   -----------   -------------   -----------   -----------   -----------
    14.696      0.071845      0.073785      0.1471811      248.79073     0.0040194     0.0116745
    50.000      0.194223      0.191321      0.0408818       66.68767     0.0149953     0.0124843
   100.000      0.361168      0.354829      0.0172567       32.45096     0.0308157     0.0127809
   200.000      0.694962      0.689088      0.0063620       15.87715     0.0629836     0.0130285
   300.000      1.032606      1.032725      0.0032416       10.43493     0.0958320     0.0131912
   400.000      1.376343      1.385467      0.0020047        7.73116     0.1293466     0.0133359
   500.000      1.726970      1.746875      0.0014726        6.11564     0.1635153     0.0134801
   600.000      2.084856      2.116414      0.0012496        5.04226     0.1983238     0.0136311
   700.000      2.450170      2.493642      0.0011818        4.27805     0.2337512     0.0137930
   800.000      2.822964      2.878241      0.0012078        3.70688     0.2697685     0.0139685
   900.000      3.203202      3.269964      0.0013030        3.26435     0.3063395     0.0141597
  1000.000      3.590775      3.668596      0.0014586        2.91188     0.3434207     0.0143685
  1200.000      4.387395      4.485805      0.0019464        2.38713     0.4189129     0.0148448
  1500.000      5.630718      5.757452      0.0031437        1.87084     0.5345198     0.0157254
  2000.000      7.796742      7.969823      0.0063881        1.37295     0.7283612     0.0176896
  2500.000      9.995728     10.220407      0.0108660        1.09369     0.9143353     0.0202584
  2750.000     11.068486     11.320859      0.0133088        0.99874     1.0012600     0.0217164
  3000.000     12.095703     12.375695      0.0156184        0.92344     1.0829033     0.0232338
  3250.000     13.052346     13.358051      0.0175050        0.86297     1.1587874     0.0247517
  3500.000     13.913454     14.241183      0.0186614        0.81373     1.2289047     0.0262050
  3750.000     14.656843     15.002199      0.0188098        0.77298     1.2937018     0.0275280
  4000.000     15.343813     15.705285      0.0188412        0.73848     1.3541393     0.0288002
  4500.000     16.588334     16.978825      0.0189058        0.68329     1.4635171     0.0312264
  5000.000     17.685984     18.101756      0.0189860        0.64113     1.5597420     0.0335074
  5500.000     18.662839     19.100723      0.0190886        0.60788     1.6450519     0.0356668
  6000.000     19.539649     19.996937      0.0192139        0.58097     1.7212602     0.0377296
  6500.000     20.332803     20.807171      0.0193596        0.55872     1.7898196     0.0397189
  7000.000     21.055248     21.544696      0.0195225        0.53999     1.8518948     0.0416538
  7500.000     21.717285     22.220086      0.0196987        0.52399     1.9084266     0.0435502
  8000.000     22.327184     22.841847      0.0198844        0.51016     1.9601815     0.0454207
END

set output "Figures/BOT_005_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs (Mscf/stb)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_005_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Bo (rb/stb)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_005_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rv (stb/Mscf)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_005_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "1/Bg (Mscf/rb)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_005_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_005_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Density (lbm/ft3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_005_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs and 1/Rv (Mscf/stb)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set title "Three-Stage Black Oil Tables for Gas Cap 2"
show title

$BOT_BP << END
#   Psat        EOS Deno      BO Deno           Rs             Bo          1/Bo         Viso
#  (psia)      (lbm/ft3)     (lbm/ft3)      (Mscf/stb)      (rb/stb)     (stb/rb)       (cp)
#----------   -----------   -----------   -------------   -----------   ----------   ---------
    14.696      52.3020       52.4442      4.79487e-04      1.05783      0.945330     3.06858
    50.000      51.9722       52.3612      2.39334e-03      1.05989      0.943496     2.89926
   100.000      51.7839       52.1759      1.27145e-02      1.06570      0.938354     2.81635
   200.000      51.5202       51.8718      3.19881e-02      1.07578      0.929555     2.70403
   300.000      51.3099       51.6064      5.03247e-02      1.08499      0.921667     2.61523
   400.000      51.1180       51.3627      6.80695e-02      1.09371      0.914320     2.53403
   500.000      50.9356       51.1333      8.54785e-02      1.10214      0.907330     2.45691
   600.000      50.7591       50.9143      1.02692e-01      1.11037      0.900601     2.38270
   700.000      50.5868       50.7036      1.19793e-01      1.11847      0.894078     2.31095
   800.000      50.4177       50.4997      1.36835e-01      1.12647      0.887726     2.24149
   900.000      50.2513       50.3018      1.53850e-01      1.13440      0.881520     2.17424
  1000.000      50.0872       50.1091      1.70865e-01      1.14228      0.875445     2.10918
  1200.000      49.7646       49.7357      2.05067e-01      1.15796      0.863588     1.98501
  1500.000      49.2950       49.2049      2.56732e-01      1.18131      0.846521     1.81456
  2000.000      48.5503       48.3882      3.43947e-01      1.21988      0.819756     1.57074
  2500.000      47.8530       47.6478      4.32420e-01      1.25802      0.794899     1.37161
  2750.000      47.5206       47.3022      4.77198e-01      1.27700      0.783087     1.28597
  3000.000      47.1985       46.9710      5.22400e-01      1.29595      0.771635     1.20831
  3250.000      46.8861       46.6530      5.68069e-01      1.31490      0.760512     1.13770
  3500.000      46.5827       46.3469      6.14256e-01      1.33389      0.749687     1.07329
  3750.000      46.2875       46.0514      6.61025e-01      1.35294      0.739129     1.01430
  4000.000      46.0016       45.7671      7.08305e-01      1.37203      0.728849     0.96050
  4500.000      45.4608       45.2332      8.04066e-01      1.41011      0.709166     0.86713
  5000.000      44.9546       44.7387      9.01713e-01      1.44825      0.690487     0.78869
  5500.000      44.4801       44.2801      1.00125e+00      1.48649      0.672727     0.72217
  6000.000      44.0340       43.8536      1.10275e+00      1.52487      0.655794     0.66517
  6500.000      43.6118       43.4548      1.20649e+00      1.56354      0.639574     0.61565
  7000.000      43.2075       43.0779      1.31310e+00      1.60280      0.623908     0.57184
  7500.000      42.8127       42.7149      1.42381e+00      1.64321      0.608564     0.53210
  8000.000      42.4155       42.3546      1.54083e+00      1.68575      0.593208     0.49487
END

$BOT_DP << END
#   Psat        EOS Deng      BO Deng           Rv             Bg           1/Bg          Visg
#  (psia)      (lbm/ft3)     (lbm/ft3)      (stb/Mscf)     (rb/Mscf)     (Mscf/rb)        (cp)
#----------   -----------   -----------   -------------   -----------   -----------   -----------
    14.696      0.071845      0.074364      0.1471811      248.79073     0.0040194     0.0116745
    50.000      0.194223      0.189008      0.0408818       66.68767     0.0149953     0.0124843
   100.000      0.361168      0.348031      0.0172567       32.45096     0.0308157     0.0127809
   200.000      0.694962      0.673269      0.0063620       15.87715     0.0629836     0.0130285
   300.000      1.032606      1.007817      0.0032416       10.43493     0.0958320     0.0131912
   400.000      1.376343      1.351399      0.0020047        7.73116     0.1293466     0.0133359
   500.000      1.726970      1.703563      0.0014726        6.11564     0.1635153     0.0134801
   600.000      2.084856      2.063757      0.0012496        5.04226     0.1983238     0.0136311
   700.000      2.450170      2.431535      0.0011818        4.27805     0.2337512     0.0137930
   800.000      2.822964      2.806584      0.0012078        3.70688     0.2697685     0.0139685
   900.000      3.203202      3.188674      0.0013030        3.26435     0.3063395     0.0141597
  1000.000      3.590775      3.577616      0.0014586        2.91188     0.3434207     0.0143685
  1200.000      4.387395      4.375399      0.0019464        2.38713     0.4189129     0.0148448
  1500.000      5.630718      5.618374      0.0031437        1.87084     0.5345198     0.0157254
  2000.000      7.796742      7.786941      0.0063881        1.37295     0.7283612     0.0176896
  2500.000      9.995728     10.002317      0.0108660        1.09369     0.9143353     0.0202584
  2750.000     11.068486     11.088900      0.0133088        0.99874     1.0012600     0.0217164
  3000.000     12.095703     12.131841      0.0156184        0.92344     1.0829033     0.0232338
  3250.000     13.052346     13.103243      0.0175050        0.86297     1.1587874     0.0247517
  3500.000     13.913454     13.974944      0.0186614        0.81373     1.2289047     0.0262050
  3750.000     14.656843     14.722461      0.0188098        0.77298     1.2937018     0.0275280
  4000.000     15.343813     15.412598      0.0188412        0.73848     1.3541393     0.0288002
  4500.000     16.588334     16.662762      0.0189058        0.68329     1.4635171     0.0312264
  5000.000     17.685984     17.765263      0.0189860        0.64113     1.5597420     0.0335074
  5500.000     18.662839     18.746299      0.0190886        0.60788     1.6450519     0.0356668
  6000.000     19.539649     19.626700      0.0192139        0.58097     1.7212602     0.0377296
  6500.000     20.332803     20.422919      0.0193596        0.55872     1.7898196     0.0397189
  7000.000     21.055248     21.147964      0.0195225        0.53999     1.8518948     0.0416538
  7500.000     21.717285     21.812187      0.0196987        0.52399     1.9084266     0.0435502
  8000.000     22.327184     22.423907      0.0198844        0.51016     1.9601815     0.0454207
END

set output "Figures/BOT_006_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs (Mscf/stb)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_006_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Bo (rb/stb)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_006_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rv (stb/Mscf)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_006_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "1/Bg (Mscf/rb)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_006_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_006_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Density (lbm/ft3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_006_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (psia)"
set ylabel "Rs and 1/Rv (Mscf/stb)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set output
